//-Normal-----------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Normal Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobNormal::OnEnter(%this, %cmpAI)
{
   echo("Job Normal");
   
   // Reset lost happiness
   RestoreLostHappinessFromJob(%cmpAI);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Normal Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobNormal::OnExit(%this, %cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Normal Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobNormal::Update(%this, %cmpAI)
{
   AICheckWorkForFire(%cmpAI);
   
   // If character doesn't have job go to next stage
   if(IsJobless(%cmpAI) && AreMonitoringJob()) {
      ReturnValue(%cmpAI, 0);
   }
   
   // Otherwise stay in normal update
   else {
      ReturnValue(%cmpAI, -1);
   }
   return;
}
//------------------------------------------------------------------------------

//-Stage One--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage One Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage1::OnEnter(%this,%cmpAI)
{
   echo("Job Stage One");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage One Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage1::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage One Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage1::Update(%this,%cmpAI)
{
   AICheckWorkForFire(%cmpAI);
   
   // Found a job   
   if(!IsJobless(%cmpAI) || !AreMonitoringJob()) {
      ReturnValue(%cmpAI,0);
      return;
   }
 
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.joblessWaitTimes_0;  
   
   // Go to stage two
   if(TimeInNode(%cmpAI) >= %totalTime) {
      ReturnValue(%cmpAI,1);
   }
   
   // Stay in stage one
   else {
      ReturnValue(%cmpAI,-1);
   }
   
   return;
}
//------------------------------------------------------------------------------

//-Stage Two--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Two Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage2::OnEnter(%this,%cmpAI)
{
   echo("Job Stage Two");
   
   // Character at -1 happiness
   LoseHappinessFromJob(%cmpAI);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Two Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage2::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Two Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage2::Update(%this,%cmpAI)
{
   AICheckWorkForFire(%cmpAI);
   
   // Found a job   
   if(!IsJobless(%cmpAI) || !AreMonitoringJob()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.joblessWaitTimes_1;
   
   // Go to stage three
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Test protesting
      %percent = %datablock.joblessProtestPercent;
      %happy   = %datablock.joblessProtestHappyMod;
      if(CheckForMonitorEffect(%percent, %happy, 0)) {
         // Start protesting
         %cmpChar = slgQueryInterface(GetThisObject(%cmpAI), $CID_CHARACTER);
         %cmpChar.protestWork();
      }
      ReturnValue(%cmpAI,1);
   }
   
   // Stay in stage two   
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------

//-Stage Three------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Three Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage3::OnEnter(%this,%cmpAI)
{
   echo("Job Stage Three");
   
   // Character at -2 unhappiness
   LoseHappinessFromJob(%cmpAI);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage3::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage3::Update(%this,%cmpAI)
{
   AICheckWorkForFire(%cmpAI);
   
   // Found a job   
   if(!IsJobless(%cmpAI) || !AreMonitoringJob()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.joblessWaitTimes_2;
   
   // Go to stage four or become drunk
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Check chance to become drunk
      %drunkPercent = %datablock.joblessDrunkPercent;
      %happyMod     = %datablock.joblessDrunkHappyMod;
      if(CheckForMonitorEffect(%drunkPercent, %happyMod, 0) && TeamBuildingExists(%cmpAI, "Saloon")) {
         ReturnValue(%cmpAI, 2);
      }
            
      // Go to stage four
      else {
         ReturnValue(%cmpAI,1);
      }
   }
   
   // Stay in stage three
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------

//-Stage Four-------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Three Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage4::OnEnter(%this,%cmpAI)
{
   echo("Job Stage Four");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage4::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage4::Update(%this,%cmpAI)
{
   AICheckWorkForFire(%cmpAI);
   
   // Found a job   
   if(!IsJobless(%cmpAI) || !AreMonitoringJob()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.joblessWaitTimes_3;
   
   // Go to stage five or become drunk
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Check chance to become drunk
      %drunkPercent = %datablock.joblessDrunkPercent;
      %happyMod     = %datablock.joblessDrunkHappyMod;
      if(CheckForMonitorEffect(%drunkPercent, %happyMod, 1) && TeamBuildingExists(%cmpAI, "Saloon")) {
         ReturnValue(%cmpAI, 2);
      }
      
      // Go to stage five
      else {
         ReturnValue(%cmpAI,1);
      }
   }
   
   // Stay in stage four
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------

//-Stage Five-------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Three Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage5::OnEnter(%this,%cmpAI)
{
   echo("Job Stage Five");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage5::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage5::Update(%this,%cmpAI)
{
   AICheckWorkForFire(%cmpAI);
   
   // Found a job   
   if(!IsJobless(%cmpAI) || !AreMonitoringJob()) {
      ReturnValue(%cmpAI,0);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.joblessWaitTimes_4;
   
   // Go to stage six
   if(TimeInNode(%cmpAI) >= %totalTime) {
      // Test protesting
      %percent = %datablock.joblessProtestPercent;
      %happy   = %datablock.joblessProtestHappyMod;
      if(CheckForMonitorEffect(%percent, %happy, 1)) {
         // Start protesting
         %cmpChar = slgQueryInterface(GetThisObject(%cmpAI), $CID_CHARACTER);
         %cmpChar.protestWork();
      }
      ReturnValue(%cmpAI,1);
   }
   
   // Stay in stage five
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------

//-Stage Six--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Three Enter Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage6::OnEnter(%this,%cmpAI)
{
   echo("Job Stage Six");
   
   // Character at -3 unhappiness at this stage
   LoseHappinessFromJob(%cmpAI);
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Exit Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage6::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Update Method
//! \param %cmpAI AI component of character object
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorJobStage6::Update(%this,%cmpAI)
{
   AICheckWorkForFire(%cmpAI);
   
   // Stay in this state until a job is found   
   if(!IsJobless(%cmpAI) || !AreMonitoringJob()) {
      ReturnValue(%cmpAI,0);
   }
   
   // Stay in stage six
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------

function AICheckWorkForFire(%data)
{
   if (isObject(%data) == false)
   {
      return;
   }
   
   // if there are actions to perform, this character
   // should not cancel them to put out a fire
   if (%data.getActionCount() > 0)
   {
      return;
   }
   
   // if the is selected, do not force fire fighting
   %object = GetThisObject(%data);
   if (slgIsSelected(%object) == true)
   {
      return;
   }
   
   // ensure that this is a character
   %character = slgQueryInterface(%object, $CID_CHARACTER);
   if (isObject(%character) == false)
   {
      return;
   }
   
   // before checking if the character's work is on fire, make
   // sure the character has a job
   if (%character.hasWork() == false)
   {
      return;
   }
   
   // get the work of the character
   %work = %character.getWork();
   %building = slgQueryInterface(%work, $CID_BUILDING);
   if (isObject(%building) == false)
   {
      return;
   }

   // check if the work is on fire   
   if (%building.onFire() == true)
   {
      %data.performAction("fightfire", %work);
   }
}
